--
-- DE2 top-level module
--
-- Stephen A. Edwards, Columbia University, sedwards@cs.columbia.edu
--
-- From an original by Terasic Technology, Inc.
-- (DE2_TOP.v, part of the DE2 system board CD supplied by Altera)
--

library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity guitar_top is

  port (
signal CLOCK_50 : in std_logic; 

SRAM_DQ : inout std_logic_vector(15 downto 0);
SRAM_ADDR : out std_logic_vector(17 downto 0);
KEY : in std_logic_vector(3 downto 0);
SRAM_UB_N,
SRAM_LB_N, 
SRAM_WE_N, 
SRAM_CE_N, 
SRAM_OE_N : out std_logic ;
 
GPIO_0,                                      -- GPIO Connection 0
GPIO_1 : inout std_logic_vector(35 downto 0) -- GPIO Connection 1   









    );
  
end guitar_top;

architecture datapath of guitar_top is

signal reset_n :std_logic;
signal new_res:std_logic;
 signal audio_clock : unsigned(1 downto 0) := "00";
signal counter : unsigned(15 downto 0);

-- for beats
signal counter2 : unsigned(31 downto 0);
signal beat :std_logic := '1';

-- store beats here
--constant ROM : concrete_rom :=(x"00b4",x"00c8",x"00f0",x"0116",x"0141",x"016a",x"0193",x"01bb",x"01e3",x"020a",x"0232",x"025a",x"0281",x"02a8",x"02d1",x"02fa",x"0321",x"0348",x"0370",x"039a",x"03c1",x"03eb",x"0414",x"043a",x"0463",x"048a",x"04b3",x"04da",x"0503",x"052b",x"0553",x"057a",x"05a2",x"05ca",x"05f2",x"061a",x"0642",x"066a",x"0692",x"06ba",x"06e2",x"0709",x"0731",x"0759",x"0781",x"07a8",x"07d0",x"07f8",x"0820",x"0848",x"0872",x"0898",x"08bd",x"08e4",x"090c",x"0933",x"095a",x"0981",x"09ac",x"09d7",x"0a00",x"0a25",x"0a4c",x"0a75",x"0a9c",x"0ac4",x"0aef",x"0b17",x"0b40",x"0b68",x"0b8f",x"0bb6",x"0bde",x"0c06",x"0c2f",x"0c56",x"0c7e",x"0ca6",x"0cce",x"0cf6",x"0d1e",x"0d45",x"0d70",x"0d98",x"0dc0",x"0de4",x"0e0c",x"0e34",x"0e5c",x"0e85",x"0eac",x"0ed4",x"0efb",x"0f24",x"0f4b",x"0f71",x"0f98",x"0fc2",x"0feb",x"1014",x"103c",x"1064",x"108b",x"10b3",x"10db",x"1103",x"112b",x"1153",x"117b",x"11a2",x"11cb",x"11f2",x"121a",x"1243",x"126c",x"1292",x"12bb",x"12e2",x"130a",x"1332",x"135a",x"1382",x"13aa",x"13d1",x"13f9",x"1421",x"144a",x"1471",x"1499",x"14c2",x"14e8",x"1510",x"153a",x"1560",x"1588",x"15b0",x"15d9",x"15ff",x"1628",x"164f",x"1677",x"169f",x"16c7",x"16ee",x"1717",x"173f",x"1768",x"178f",x"17b9",x"17df",x"1808",x"182e",x"1856",x"187e",x"18a6",x"18cd",x"18f6",x"191d",x"1945",x"196d",x"1995",x"19bd",x"19e6",x"1a0d",x"1a36",x"1a5e",x"1a85",x"1aad",x"1ad4",x"1afc",x"1b23",x"1b4c",x"1b73",x"1b9c",x"1bc4",x"1bec",x"1c14",x"1c3b",x"1c64",x"1c8c",x"1cb3",x"1cdb",x"1d03",x"1d2b",x"1d53",x"1d78",x"1d9c",x"1dbf",x"1de2",x"1e0a",x"1e32",x"1e5b",x"1e81",x"1eaa",x"1ed4",x"1f01",x"1f31",x"1f5a",x"1f83",x"1faa",x"1fd1",x"1ff9",x"2022",x"204a",x"2071",x"2099",x"20c1",x"20e9",x"2111",x"2139",x"2160",x"2188",x"21b0",x"21d9",x"2200",x"2228",x"2250",x"2279",x"22a2",x"22ca",x"22f2",x"2318",x"2340",x"2366",x"238b",x"23b4",x"23e0",x"2407",x"2430",x"2458",x"2480",x"24a8",x"24d0",x"24f7",x"251e",x"2546",x"256e",x"2596",x"25bd",x"25e2",x"260c",x"2635",x"265d",x"2685",x"26ac",x"26d4",x"26fd",x"2725",x"274d",x"2775",x"279d",x"27c4",x"27ed",x"2814",x"283c",x"2864",x"288d",x"28b4",x"28dd",x"2904",x"292d",x"2955",x"297c",x"29a3",x"29ca",x"29f3",x"2a1c",x"2a43",x"2a6b",x"2a91",x"2ab9",x"2ae2",x"2b0b",x"2b32",x"2b5c",x"2b82",x"2ba9",x"2bd0",x"2bfa",x"2c20",x"2c4a",x"2c72",x"2c9b",x"2cc1",x"2cea",x"2d10",x"2d38",x"2d61",x"2d8a",x"2db0",x"2dd9",x"2e00",x"2e29",x"2e50",x"2e78",x"2ea0",x"2ec8",x"2ef0",x"2f18",x"2f40",x"2f68",x"2f8f",x"2fb7",x"2fde",x"3007",x"3030",x"3058",x"307e",x"30a5",x"30cd",x"30f5",x"311d",x"3144",x"316c",x"3194",x"31bb",x"31e4",x"320d",x"3235",x"325d",x"3286",x"32ae",x"32d7",x"32fd",x"3323",x"334c",x"3373",x"339c",x"33c4",x"33ec",x"3416",x"343c",x"3463",x"348c",x"34b4",x"34dc",x"3504",x"352d",x"3554",x"357c",x"35a2",x"35ca",x"35f1",x"361b",x"3645",x"366a",x"3692",x"36ba",x"36e2",x"370a",x"3733",x"375a",x"3782",x"37ab",x"37d3",x"37f9",x"3820",x"3847",x"386e",x"3896",x"38c0",x"38e9",x"3912",x"393a",x"3963",x"398a",x"39b1",x"39db",x"3a02",x"3a2a",x"3a52",x"3a79",x"3aa2",x"3aca",x"3af2",x"3b1c",x"3b48",x"3b6c",x"3b91",x"3bb8",x"3be0",x"3c08",x"3c31",x"3c59",x"3c80",x"3ca8",x"3cd0",x"3cf8",x"3d1f",x"3d49",x"3d70",x"3d96",x"3dbe",x"3de5",x"3e0e",x"3e36",x"3e5e",x"3e86",x"3eae",x"3ed6",x"3efe",x"3f26",x"3f4e",x"3f76",x"3f9f",x"3fc7",x"3fee",x"4015",x"403d",x"4065",x"408d",x"40b4",x"40dc",x"4104",x"412c",x"4154",x"417d",x"41a5",x"41cc",x"41f3",x"421b",x"4242",x"426b",x"4293",x"42bb",x"42e3",x"430b",x"4333",x"435a",x"4381",x"43aa",x"43d2",x"43f9",x"4422",x"444a",x"4472",x"449a",x"44c2",x"44ea",x"4512",x"4539",x"4562",x"458a",x"45b1",x"45d8",x"4601",x"4629",x"4654",x"467b",x"46a1",x"46c9",x"46f0",x"4718",x"4740",x"4768",x"4791",x"47ba",x"47e1",x"4808",x"482f",x"4857",x"487e",x"48a7",x"48d0",x"48f8",x"4920",x"4947",x"496e",x"4996",x"49be",x"49e6",x"4a0c",x"4a35",x"4a5d",x"4a84",x"4aac",x"4ad5",x"4afd",x"4b23",x"4b49",x"4b71",x"4b98",x"4bc0",x"4be6",x"4c0d",x"4c33",x"4c5d",x"4c82",x"4cad",x"4cd7",others=>x"0000");
  



begin

-- beats access
process (CLOCK_50)
begin
if rising_edge(CLOCK_50) then

if counter2 = x"00000001" then
counter2 <= x"00000000";
beat <= '1';
end if;

if counter2 = x"000000000" then
counter2 <= x"00000001";
beat <= '0';
--else
--counter2 <= counter2 + 1;
end if;
end if;
end process;


process (CLOCK_50)
begin
if rising_edge(CLOCK_50) then
if counter = x"ffff" then
reset_n <= '1';
else
reset_n <= '0';
counter <= counter + 1;
end if;
end if;
end process;


  process (CLOCK_50)
  begin
    if rising_edge(CLOCK_50) then
      audio_clock <= audio_clock + "1";
    end if;
  end process;



nios : entity work.nios_system port map (
clk => CLOCK_50,
reset_n => reset_n,
SRAM_ADDR_from_the_sram => SRAM_ADDR,
SRAM_CE_N_from_the_sram => SRAM_CE_N,
SRAM_DQ_to_and_from_the_sram => SRAM_DQ,
SRAM_LB_N_from_the_sram => SRAM_LB_N,
SRAM_OE_N_from_the_sram => SRAM_OE_N,
SRAM_UB_N_from_the_sram => SRAM_UB_N,
SRAM_WE_N_from_the_sram => SRAM_WE_N,
--SWITCH_1_to_the_InputController_inst => GPIO_0(0),
--SWITCH_2_to_the_InputController_inst => GPIO_0(1) ,
--SWITCH_3_to_the_InputController_inst => GPIO_0(2) ,
--SWITCH_4_to_the_InputController_inst => GPIO_0(3), 
--SWITCH_5_to_the_InputController_inst => GPIO_0(4)
--SWITCH_1_to_the_InputController_inst => KEY(0),--
SWITCH_1_to_the_InputController_inst => GPIO_0(0),
SWITCH_2_to_the_InputController_inst => '1' ,
SWITCH_3_to_the_InputController_inst => '1',
SWITCH_4_to_the_InputController_inst => '1', 
SWITCH_5_to_the_InputController_inst => '1',
--SWITCH_1_to_the_InputController2_inst => GPIO_0(0),
--SWITCH_2_to_the_InputController2_inst => GPIO_0(1) ,
--SWITCH_3_to_the_InputController2_inst => GPIO_0(2) ,
--SWITCH_4_to_the_InputController2_inst => GPIO_0(3), 
--SWITCH_5_to_the_InputController2_inst => GPIO_0(4)
SWITCH_1_to_the_InputController2_inst => '1' ,
--SWITCH_2_to_the_InputController2_inst => KEY(1) ,--
SWITCH_2_to_the_InputController2_inst => GPIO_0(1) ,
SWITCH_3_to_the_InputController2_inst => '1'  ,
SWITCH_4_to_the_InputController2_inst => '1' , 
SWITCH_5_to_the_InputController2_inst => '1',
--SWITCH_1_to_the_InputController3_inst => GPIO_0(0),
--SWITCH_2_to_the_InputController3_inst => GPIO_0(1) ,
--SWITCH_3_to_the_InputController3_inst => GPIO_0(2) ,
--SWITCH_4_to_the_InputController3_inst => GPIO_0(3), 
--SWITCH_5_to_the_InputController3_inst => GPIO_0(4)
SWITCH_1_to_the_InputController3_inst => '1' ,
SWITCH_2_to_the_InputController3_inst => '1' ,
--SWITCH_3_to_the_InputController3_inst => KEY(2)  ,--
SWITCH_3_to_the_InputController3_inst => GPIO_0(2) ,
SWITCH_4_to_the_InputController3_inst => '1' , 
SWITCH_5_to_the_InputController3_inst => '1',
--SWITCH_1_to_the_InputController4_inst => GPIO_0(0),
--SWITCH_2_to_the_InputController4_inst => GPIO_0(1) ,
--SWITCH_3_to_the_InputController4_inst => GPIO_0(2) ,
--SWITCH_4_to_the_InputController4_inst => GPIO_0(3), 
--SWITCH_5_to_the_InputController4_inst => GPIO_0(4)
SWITCH_1_to_the_InputController4_inst => '1' ,
SWITCH_2_to_the_InputController4_inst => '1' ,
SWITCH_3_to_the_InputController4_inst => '1'  ,
--SWITCH_4_to_the_InputController4_inst => KEY(3) ,-- 
SWITCH_4_to_the_InputController4_inst => GPIO_0(3), 
SWITCH_5_to_the_InputController4_inst => '1',
--SWITCH_1_to_the_InputController5_inst => GPIO_0(0),
--SWITCH_2_to_the_InputController5_inst => GPIO_0(1) ,
--SWITCH_3_to_the_InputController5_inst => GPIO_0(2) ,
--SWITCH_4_to_the_InputController5_inst => GPIO_0(3), 
--SWITCH_5_to_the_InputController5_inst => GPIO_0(4)
SWITCH_1_to_the_InputController5_inst => '1' ,
SWITCH_2_to_the_InputController5_inst => '1' ,
SWITCH_3_to_the_InputController5_inst => '1'  ,
SWITCH_4_to_the_InputController5_inst => '1' , 
--SWITCH_5_to_the_InputController5_inst => '1',--
SWITCH_5_to_the_InputController5_inst => GPIO_0(4),
SWITCH_1_to_the_InputController6_inst => '1' ,
SWITCH_2_to_the_InputController6_inst => '1' ,
SWITCH_3_to_the_InputController6_inst => '1'  ,
SWITCH_4_to_the_InputController6_inst => beat , 
SWITCH_5_to_the_InputController6_inst => '1'
);


  

end datapath;
